<?php
   
namespace App\Http\Controllers\API;
   
use Illuminate\Http\Request;
use App\Http\Controllers\API\BaseController as BaseController;
use Validator;
use DB;
use Illuminate\Http\JsonResponse;
   
class FrontController extends BaseController
{

    public function home(Request $request): JsonResponse
    {
        
        $limit = $request->limit ? $request->limit : 10;        
        $page = $request->page && $request->page > 0 ? $request->page : 1;
        $skip = ($page - 1) * $limit;

           // $data['blog'] = DB::table('blog')->where('status', 1)->orderBy('id', 'DESC')->take($limit)->skip($skip)->get();
           // $data['banner'] = DB::table('banner')->select('id','title','content', 'image')->where('status', 1)->get();
            
            $data['about'] = DB::table('about')->select('id','title','content')->where('status', 1)->get();
            
            $data['home_business_area'] = DB::table('page_content')->select('name','slug','title','sub_title','image','content')->where('status', 1)->where('name', 'home_business_area')->first();
            $data['business_area'] = DB::table('business_area')->select('*')->where('status', 1)->get();
            $data['process'] = DB::table('page_content')->select('name','slug','title','sub_title','image','content')->where('status', 1)->where('name', 'home_process')->first();
            $data['career'] = DB::table('page_content')->select('name','slug','title','sub_title','image','content','text_one','text_two','text_three','text_four')->where('status', 1)->where('name', 'home_career')->first();
            $data['resource'] = DB::table('page_content')->select('name','slug','title','sub_title','image','content','text_one','text_two','text_three','text_four')->where('status', 1)->where('name', 'home_resource')->first();
            $data['investor'] = DB::table('page_content')->select('name','slug','title','sub_title','image','content','text_one','text_two','text_three','text_four')->where('status', 1)->where('name', 'home_investor')->first();
            $data['sustainability'] = DB::table('page_content')->select('name','slug','title','sub_title','image','content','text_one','text_two','text_three','text_four')->where('status', 1)->where('name', 'home_sustainability')->first();
            $data['award'] = DB::table('page_content')->select('name','slug','title','sub_title','image','content','text_one','text_two','text_three','text_four')->where('status', 1)->where('name', 'home_award')->first();
            $data['award_slide'] = DB::table('award')->select('*')->where('status', 1)->orderBy('id', 'DESC')->get();
            $data['testimonial'] = DB::table('page_content')->select('*')->where('status', 1)->where('name', 'home_testimonial')->first();
            $data['press_releases'] = DB::table('page_content')->select('*')->where('status', 1)->where('name', 'home_press_release')->first();
            $data['latest_blog'] = DB::table('page_content')->select('*')->where('status', 1)->where('name', 'home_blog')->first();
            
         
            if ($data) {
                return $this->sendResponse($data, 'success');
            } else {
                return $this->sendError('fail');
            }
        
    }

    public function blog(Request $request): JsonResponse
    {
        
           $year = $request->year ? $request->year : "";    
           $blog_id = $request->blog_id ? $request->blog_id : "";        
           $limit = $request->last_rowcount ? $request->last_rowcount : 0; 

            $query = DB::table('blog')->where('status', 1);
            if(!empty($year)){
                $query = $query->whereYear('created_at', '=', $year);
            }
            if(!empty($blog_id)){
                $query = $query->where('id', $blog_id);
            }
            $query = $query->orderBy('id', 'DESC')->skip($limit)->take(6)->get();
   
            if ($query->count()) {
                return $this->sendResponse($query, 'success');
            }else{
                return $this->sendError('fail');
            }

    }

    public function latest_blog(Request $request): JsonResponse
    {

            $query = DB::table('blog')->select('id','title','image')->where('status', 1)->orderBy('id', 'DESC')->skip(0)->take(5)->get();
   
            if ($query->count()) {
                return $this->sendResponse($query, 'success');
            }else{
                return $this->sendError('fail');
            }
    }
    
    

    public function investor(Request $request): JsonResponse
    {
        $category = $request->category ? $request->category : '';
        $year = $request->year ? $request->year : date('Y');
        $limit = $request->limit ? $request->limit : 1000;        
        $page = $request->page && $request->page > 0 ? $request->page : 1;
        $skip = ($page - 1) * $limit;

            $query = DB::table('investor');
                if(!empty($category)){
                    $query = $query->where('category_name', $request->category);
                }
                if(!empty($year)){
                    $query = $query->whereYear('created_at', '=', $year);
                }
            $query = $query->where('status', 1);
            $query = $query->select('id','category_id','category_name','slug','type_of_content','content','title','url','pdf','status','type','sort_order','created_at');
            $query = $query->orderBy('id', 'DESC');
            $data = $query->get();
            //$data = $query->take($limit)->skip($skip)->get();

            //$data['banner'] = DB::table('banner')->select('id','title','content', 'image')->where('status', 1)->where('name', 'investor')->get();

            if ($data->count()) {
                return $this->sendResponse($data, 'success');
            }else{
                return $this->sendError('fail');
            }
    }

    public function banner(Request $request): JsonResponse
    {
        
            $banner = DB::table('banner')->where('status', 1)->where('name', $request->name)->get();
            
            if ($banner->count()) {
                return $this->sendResponse($banner, 'success');
            }else{
                return $this->sendError('fail');
            }
        
    }
    public function about(Request $request): JsonResponse
    {
        
        $limit = $request->limit ? $request->limit : 10;        
        $page = $request->page && $request->page > 0 ? $request->page : 1;
        $skip = ($page - 1) * $limit;

            $blog = DB::table('about')->where('status', 1)->orderBy('id', 'DESC')->take($limit)->skip($skip)->get();
            
            if ($blog->count()) {
                return $this->sendResponse($blog, 'success');
            }else{
                return $this->sendError('fail');
            }
        
    }

    public function brands(Request $request): JsonResponse
    {
        
        $limit = $request->limit ? $request->limit : 10;        
        $page = $request->page && $request->page > 0 ? $request->page : 1;
        $skip = ($page - 1) * $limit;

            $blog = DB::table('brands')->where('status', 1)->orderBy('id', 'DESC')->take($limit)->skip($skip)->get();
            
            if ($blog->count()) {
                return $this->sendResponse($blog, 'success');
            }else{
                return $this->sendError('fail');
            }
        
    }

    public function investor_category(Request $request): JsonResponse
    {
        
            $category = DB::table('category')
            ->join('investor', 'investor.category_id', '=', 'category.id') 
            ->select('category.id','category.category_name','investor.slug')           
            ->where('investor.status', 1) 
            ->distinct()           
            ->orderBy('category.sort_order', 'ASC')                 
            ->get();            

            if ($category->count()) {
                return $this->sendResponse($category, 'success');
            }else{
                return $this->sendError('fail');
            }
        
    }

    public function get_career(Request $request): JsonResponse
    {
         $data['banner'] = DB::table('banner')->select('id','name','slug','title','content','image')->where('status', 1)->where('name', 'career')->first();
         $data['overview'] = DB::table('work_culture')->where('name', 'overview')->first();
         $data['suboverview'] = DB::table('work_culture')->where('name', 'suboverview')->get();
         $data['coreculture'] = DB::table('work_culture')->where('name', 'coreculture')->get();
         $data['open-position'] = DB::table('work_culture')->where('name', 'open-position')->get();
         $data['skills'] = DB::table('work_culture')->where('name', 'skills')->first();
         $data['ethicalculture'] = DB::table('work_culture')->where('name', 'ethicalculture')->get();

        if ($data) {
            return $this->sendResponse($data, 'success');
        }else{
            return $this->sendError('fail');
        }

    }

    public function get_contact(Request $request): JsonResponse
    {
         $data['banner'] = DB::table('banner')->select('id','name','slug','title','content','image')->where('status', 1)->where('name', 'contact')->first();
         $data['reg_add'] = DB::table('contacts')->select('id','name','title','content','direction')->where('status', 1)->where('name', 'registered_office')->first();
         $data['plant'] = DB::table('contacts')->select('id','name','title','content','direction')->where('status', 1)->where('name', 'plants')->get();
         $data['partner'] = DB::table('contacts')->select('id','name','title','content','direction')->where('status', 1)->where('name', 'become_partner')->first();
         $data['state'] = DB::table('states')->select('id','name')->get();
    
            
        if ($data) {
            return $this->sendResponse($data, 'success');
        }else{
            return $this->sendError('fail');
        }

    }

    public function get_about(Request $request): JsonResponse
    {
         $data['banner'] = DB::table('banner')->select('id','name','slug','title','content','image')->where('status', 1)->where('name', 'about')->first();
         $data['about'] = DB::table('about')->select('id','name','title','sub_title','content','image')->where('status', 1)->where('name', 'about')->first();
         $data['message'] = DB::table('about')->select('id','name','title','sub_title','content','image')->where('status', 1)->where('name', 'message')->first();
         $data['vision'] = DB::table('about')->select('id','name','title','sub_title','content','image')->where('status', 1)->where('name', 'vision')->first();
         $data['mission'] = DB::table('about')->select('id','name','title','sub_title','content','image')->where('status', 1)->where('name', 'mission')->first();
         $data['philosophy'] = DB::table('about')->select('id','name','title','sub_title','content','image')->where('status', 1)->where('name', 'philosophy')->first();
         $data['philosophy_bottom'] = DB::table('about')->select('id','name','title','sub_title','content','image')->where('status', 1)->where('name', 'philosophy_bottom')->get();
         $data['director'] = DB::table('about')->select('id','name','title','sub_title','content','image')->where('status', 1)->where('name', 'director')->first();
         $data['director_grid'] = DB::table('about')->select('id','name','title','sub_title','content','image')->where('status', 1)->where('name', 'director_grid')->get();
            
        if ($data) {
            return $this->sendResponse($data, 'success');
        }else{
            return $this->sendError('fail');
        }

    }
    public function get_csr(Request $request): JsonResponse
    {
        $data['banner'] = DB::table('banner')->select('id','name','slug','title','content','image')->where('status', 1)->where('name', 'csr')->first();
        $data['csr_initiative'] = DB::table('about')->select('*')->where('status', 1)->where('name', 'csr_initiative')->get();         
        $data['csr_bottom'] = DB::table('about')->select('*')->where('status', 1)->where('name', 'csr_bottom')->first();         
        
        if ($data) {
            return $this->sendResponse($data, 'success');
        }else{
            return $this->sendError('fail');
        }

    }

    public function get_partner(Request $request): JsonResponse
    {
        $data['banner'] = DB::table('banner')->select('id','name','slug','title','content','image')->where('status', 1)->where('name', 'csr')->first();
        $data['overview_left'] = DB::table('about')->select('*')->where('status', 1)->where('name', 'overview_left')->first();         
        $data['overview_right'] = DB::table('about')->select('*')->where('status', 1)->where('name', 'overview_right')->get();         
        $data['benefits'] = DB::table('about')->select('*')->where('status', 1)->where('name', 'benefits')->get();         
        $data['testimonial'] = DB::table('testimonial')->select('*')->where('status', 1)->get();         
        
        if ($data) {
            return $this->sendResponse($data, 'success');
        }else{
            return $this->sendError('fail');
        }

    }

    public function get_our_story(Request $request): JsonResponse
    {
        $data['banner'] = DB::table('banner')->select('id','name','slug','title','content','image')->where('status', 1)->where('name', 'success_story')->first();
        $data['overview'] = DB::table('policy')->select('*')->where('status', 1)->where('type', 'overview')->first();      
        $data['overview_slider'] = DB::table('policy')->select('*')->where('status', 1)->where('type', 'overview_slider')->get();         
        $data['award'] = DB::table('page_content')->select('name','slug','title','sub_title','image','content','text_one','text_two','text_three','text_four')->where('status', 1)->where('name', 'home_award')->first();
        $data['award_slide'] = DB::table('award')->select('*')->where('status', 1)->orderBy('id', 'DESC')->get();
        
        if ($data) {
            return $this->sendResponse($data, 'success');
        }else{
            return $this->sendError('fail');
        }

    }

    public function event(Request $request): JsonResponse
    {
        
           $year = $request->year ? $request->year : "";
           $blog_id = $request->blog_id ? $request->blog_id : "";
           $limit = $request->last_rowcount ? $request->last_rowcount : 0;

            $query = DB::table('event')->where('status', 1);
            if(!empty($year)){
                $query = $query->whereYear('created_at', '=', $year);
            }
            if(!empty($blog_id)){
                $query = $query->where('id', $blog_id);
            }
            $query = $query->orderBy('id', 'DESC')->skip($limit)->take(15)->get();
   
            if ($query->count()) {
                return $this->sendResponse($query, 'success');
            }else{
                return $this->sendError('fail');
            }

    }

    public function latest_event(Request $request): JsonResponse
    {

            $query = DB::table('event')->select('id','title','image')->where('status', 1)->orderBy('id', 'DESC')->skip(0)->take(5)->get();
   
            if ($query->count()) {
                return $this->sendResponse($query, 'success');
            }else{
                return $this->sendError('fail');
            }
    }


    // NXT Program 
    public function get_nxt(Request $request): JsonResponse
    {
        $data['banner'] = DB::table('banner')->select('id','name','slug','title','content','image')->where('status', 1)->where('name', 'nxt')->first();
        
        $data['about_nxt'] = DB::table('about')->where('status', 1)->where('name', 'about_nxt')->first();      
        $data['benefits'] = DB::table('about')->where('status', 1)->where('name', 'benefits')->get();         
        $data['nxt_suitable'] = DB::table('about')->where('status', 1)->where('name', 'nxt_suitable')->get();         
        $data['precision'] = DB::table('about')->where('status', 1)->where('name', 'precision')->first();         
        $data['step'] = DB::table('about')->where('status', 1)->where('name', 'step')->get();         
        $data['faq'] = DB::table('about')->where('status', 1)->where('name', 'faq')->get();         
        $data['building_dreams'] = DB::table('about')->where('status', 1)->where('name', 'building_dreams')->get();         
        $data['innovation'] = DB::table('about')->where('status', 1)->where('name', 'innovation')->first();         
        $data['innovation_grid'] = DB::table('about')->where('status', 1)->where('name', 'innovation_grid')->get();         
        
        
        if ($data) {
            return $this->sendResponse($data, 'success');
        }else{
            return $this->sendError('fail');
        }

    }

    public function get_cstudy(Request $request): JsonResponse
    {
        $data['banner'] = DB::table('banner')->select('id','name','slug','title','content','image')->where('status', 1)->where('name', 'case_study')->first();
        
        $data['all'] = DB::table('about')->where('status', 1)->whereIn('name', ['commercial','residential','industrial'])->orderBy('id', 'DESC')->get();      
        $data['commercial'] = DB::table('about')->where('status', 1)->whereIn('name', ['commercial'])->orderBy('id', 'DESC')->get();      
        $data['residential'] = DB::table('about')->where('status', 1)->whereIn('name', ['residential'])->orderBy('id', 'DESC')->get();      
        $data['industrial'] = DB::table('about')->where('status', 1)->whereIn('name', ['industrial'])->orderBy('id', 'DESC')->get();
        
        if ($data) {
            return $this->sendResponse($data, 'success');
        }else{
            return $this->sendError('fail');
        }

    }

    public function get_case_study_detail(Request $request): JsonResponse
    {

        $data['cs'] = DB::table('about')->where('status', 1)->where('id', $request->id)->first();

        $data['related'] = DB::table('about')->where('status', 1)->where('name', $data['cs']->name)->get();      
        
        if ($data) {
            return $this->sendResponse($data, 'success');
        }else{
            return $this->sendError('fail');
        }

    }

    public function media(Request $request): JsonResponse
    {
        
           $year = $request->year ? $request->year : "";    
               
           $limit = $request->last_rowcount ? $request->last_rowcount : 0; 

            $query = DB::table('media')->where('status', 1);
            if(!empty($year)){
                $query = $query->whereYear('created_at', '=', $year);
            }
      
            $query = $query->orderBy('id', 'DESC')->skip($limit)->take(6)->get();
   
            if ($query->count()) {
                return $this->sendResponse($query, 'success');
            }else{
                return $this->sendError('fail');
            }

    }

    public function enquiry(Request $request): JsonResponse
    {
        
        $data = [
            "type" => 'enquiry',
            "name" => $request->name,
            "email" => $request->email,
            "phone" => $request->phone,
            "pincode" => $request->pincode,
            "subject" => $request->subject,
            "content" => $request->content,
            "created_at" => date("Y-m-d H:i:s"),
            "updated_at" => date("Y-m-d H:i:s"),
        ];

          $id = DB::table('enquiry')->insertGetId($data);   
            if ($id > 0) {
                return $this->sendResponse($id, 'success');
            }else{
                return $this->sendError('fail');
            }

    }

    

    
   
}