<?php
// Allow requests from any origin
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");

$requestBody = file_get_contents('php://input');
$decode_response = json_decode($requestBody, true);
$mobileNumber = $decode_response['mobileNumber'] ?? '';

if (empty($mobileNumber)) {
    echo json_encode(["error" => "Mobile number is missing"]);
    die;
}

// Define the file path
$file = 'antara_token.txt';

// Use file_get_contents to read the contents of the file
$zohoToken = file_get_contents($file);

// Read token from file
$desktoken = file_get_contents('ageasy_token.txt');
if ($desktoken === false) {
    die("Failed to read the token file.");
}

// Helper function to handle cURL requests
function makeCurlRequest($url, $method = 'GET', $headers = [], $postFields = null) {
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => $method,
        CURLOPT_HTTPHEADER => $headers,
    ]);

    if ($postFields) {
        curl_setopt($curl, CURLOPT_POSTFIELDS, $postFields);
    }

    $response = curl_exec($curl);
    if (curl_errno($curl)) {
        curl_close($curl);
        return null; // Handle error in the calling function
    }

    curl_close($curl);
    return json_decode($response);
}

// Function to make a cURL request
function makeCurlRequestdesk($url, $method, $token, $payload = null) {
    $curl = curl_init();

    $options = array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => $method,
        CURLOPT_HTTPHEADER => array(
            'orgId: 60031797391',
            'Authorization: Zoho-oauthtoken ' . $token,
            'featureFlags: lookUp',
            'Content-Type: application/json'
        ),
    );

    if ($payload) {
        $options[CURLOPT_POSTFIELDS] = json_encode($payload);
    }

    curl_setopt_array($curl, $options);
    $response = curl_exec($curl);
    curl_close($curl);

    return $response;
}

// First API call to login and get token
$loginUrl = 'https://ageasybyantara.com/users/v1/public/external-user-login';
$loginPayload = json_encode([
    "username" => "sumit.bounthiyal@motviz.com",
    "password" => "X:@?K-r!j:kHOz&6"
]);

$loginResponse = makeCurlRequest($loginUrl, 'POST', ['Content-Type: application/json'], $loginPayload);
if (!$loginResponse || empty($loginResponse->accessToken)) {
    echo json_encode(["error" => "Failed to login"]);
    die;
}

$token = $loginResponse->accessToken;

// Fetch latest order using the token
$orderUrl = 'https://ageasybyantara.com/orders/v1/master/latest-order?customerMobile=' . $mobileNumber;
$orderResponse = makeCurlRequest($orderUrl, 'GET', ['x-access-token: ' . $token]);

if (!$orderResponse) {
    echo "No order found";
    die;
}

// Extract order details
$orderId = $orderResponse->orderId;
$orderNo = $orderResponse->orderNo;
$customerId = $orderResponse->customerId;
$placed_date = $orderResponse->placedOn;
$status = $orderResponse->status;
if($status == "Draft order created"){
    $status = "Order confirmed";
}
$source = $orderResponse->source;
$lineItems = $orderResponse->lineItems;
$customerName =  $orderResponse->customerName;
$discountApplied = $orderResponse->discountApplied;
$netSales = $orderResponse->netSales;
$appointmentId =  $orderResponse->appointmentId;
$userId =  $orderResponse->userId;
$total = $orderResponse->total;

$all_value ='[
        "data" => [
            [
                "number" =>'.$mobileNumber.',
                "Deal_Name" => '.$orderNo.',
                "Contact_Name" => '.$contact_id.',
                "Stage" => "Closed Won",
                "Order_ID" => '.$orderId.',
                "Order_Placed_date" => '.$placed_date.',
                "Order_No" => '.$orderNo.',
                "Customer_ID" =>'. $customerId.',
                "Status" => '.$status.',
                "Source" => '.$source.',
                "Appointment_Id" =>'.$appointmentId.',
                "Net_Sales" =>'.$netSales.',
                "User_Id"=>'.$userId.',
                "Customer_Name" =>'.$customerName.',
                "Discount_Applied" =>'.$discountApplied.',
                "Order_Details" => '.$subform["Order_Details"].'
            ]
        ]
    ]';
// echo $all_value;
if($status == "Order confirmed"){
     foreach ($lineItems as $item) {
 
      $item_name = $item->name;
      $sku = $item->sku;
    // Order does not exist; create a new order
    $createPayload = [
        'name' => $item_name,
        'owner' => "161263000000064001",
        'cf' => [
            'cf_order_no' => $orderNo,
            'cf_sku_code' => $sku
                            
        ],
    ];

    // print_r($createPayload);
    $createUrl = 'https://desk.zoho.in/api/v1/cm_purchased';
    $createResponse = makeCurlRequestdesk($createUrl, 'POST', $desktoken, $createPayload);
    }
    
    $searchContactUrl = 'https://desk.zoho.in/api/v1/contacts/search?phone='.$mobileNumber;
    $searchContactResponse = makeCurlRequestdesk($searchContactUrl, 'GET', $desktoken);
    $searchContactData = json_decode($searchContactResponse, true);
    $contact_id_desk = $searchContactData['data'][0]['id'];
    
    // echo "contct". $contact_id_desk;
    
    // Step 1: Search for the order by order number
    $searchUrldesk = 'https://desk.zoho.in/api/v1/cm_orders/search?field1=name%3A'.$order_no;
    $searchResponsedesk = makeCurlRequestdesk($searchUrldesk, 'GET', $desktoken);
    $searchDatadesk = json_decode($searchResponsedesk, true);
    // print_r($searchData);
    
    // Step 2: Check if the order exists or create a new one
    if (empty($searchDatadesk['data'])) {
        // Order does not exist; create a new order
        $createPayload = [
            'name' => $orderNo,
            'owner' => "161263000000064001",
            'cf' => [
                'cf_order_no' => $orderNo,
                'cf_order_id' => $orderId,
                'cf_status' => $status,
                'cf_contact' => intval($contact_id_desk),
                'cf_phone_2' => $mobileNumber
                                
            ],
        ];
    
        // print_r($createPayload);
        $createUrlDesk = 'https://desk.zoho.in/api/v1/cm_orders';
        $createResponse = makeCurlRequestdesk($createUrlDesk, 'POST', $desktoken, $createPayload);
        echo $createResponse;
    } else {
        // Order exists; update the order
        $deskOrderId = $searchDatadesk['data'][0]['id'];
        $updatePayload = [
            'name' => $orderNo,
            'owner' => "161263000000064001",
            'cf' => [
                // 'cf_order_no' => $order_no,
                // 'cf_order_id' => $order_id,
                'cf_status' => $status,
                'cf_contact' => intval($contact_id_desk),
                'cf_phone_2' => $mobileNumber
            ],
        ];
        // print_r($updatePayload);
        $updateUrldesk = 'https://desk.zoho.in/api/v1/cm_orders/' . $deskOrderId;
        $updateResponse = makeCurlRequestdesk($updateUrldesk, 'PATCH', $desktoken, $updatePayload);
        echo $updateResponse;
    }
    
}

$product_data=[];
// Prepare order details subform
$subform = ["Order_Details" => []];
foreach ($lineItems as $item) {
    $subform["Order_Details"][] = [
        "Product" => $item->name,
        "Amount" => $item->price,
        "SKU" => $item->sku,
        "Quantity" => 1
    ];
    $sku = $item->sku;
    $curl = curl_init();
    
    curl_setopt_array($curl, array(
      CURLOPT_URL => 'https://www.zohoapis.in/crm/v7/Products/search?criteria=Product_Code%3Aequals%3A'.$sku,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'Authorization: Zoho-oauthtoken '.$zohoToken
      ),
    ));
    
    $response = curl_exec($curl);
    
    curl_close($curl);
    $decode_response = json_decode($response, true);
    $product_id = $decode_response['data'][0]['id'];
    // echo $product_id;
    $product_data[] = [
        "id" => (string)$product_id // Convert the ID to string
    ];
  

}
  // Prepare the final array
    $result = [
        "data" => $product_data
    ];
    
    // Convert the array to JSON format
    $jsonResult = json_encode($result, JSON_PRETTY_PRINT);
    
    // Output the JSON
    // echo $jsonResult;

if (empty($zohoToken)) {
    $zoho = json_encode(["error" => "Failed to generate Zoho token"]);
    logMessage($zoho,$all_value);
    die;
}

// Check if order already exists in Zoho CRM
if (!empty($orderNo)) {
    $searchUrl = 'https://www.zohoapis.in/crm/v5/Deals/search?criteria=Order_No%3Aequals%3A' . $orderNo;
    $searchResponse = makeCurlRequest($searchUrl, 'GET', ['Authorization: Zoho-oauthtoken ' . $zohoToken]);

    if (!empty($searchResponse->data)) {
        foreach ($searchResponse->data as $order) {
            $order_id = $order->id;
            $updateUrl = 'https://www.zohoapis.in/crm/v6/Deals';
            $updatePayload ='{"data":[{"id":'.$order_id.',"Status":"'.$status.'","Net_Sales":"'.$netSales.'"}]}';
            break;
        }
        //  echo $updatePayload;
         $updateResponse = makeCurlRequest($updateUrl, 'PUT', ['Authorization: Zoho-oauthtoken ' . $zohoToken, 'Content-Type: application/json'], $updatePayload);
         $json_update = json_encode($updateResponse);
         logMessage($json_update,$all_value);
        //  echo $updatePayload;
         echo $json_update;
        exit();
    }
}

    // Search for contact if lead does not exist
    $contactUrl = 'https://www.zohoapis.in/crm/v3/Contacts/search?phone=' . $mobileNumber;
    $contactResponse = makeCurlRequest($contactUrl, 'GET', ['Authorization: Zoho-oauthtoken ' . $zohoToken]);
    $contact_id = $contactResponse->data[0]->id ?? null;
if(empty($contact_id)){
    // Search for lead by mobile number in Zoho CRM
$leadUrl = 'https://www.zohoapis.in/crm/v3/Leads/search?phone=' . $mobileNumber;
$leadResponse = makeCurlRequest($leadUrl, 'GET', ['Authorization: Zoho-oauthtoken ' . $zohoToken]);
$data = $leadResponse->data[0] ?? null;

$lead_id = $data->id ?? null;
if ($lead_id) {
    // Convert lead to contact
    $convertUrl = 'https://www.zohoapis.in/crm/v6/Leads/' . $lead_id . '/actions/convert';
    $convertPayload = json_encode([
        "data" => [
            [
                "overwrite" => true,
                "notify_lead_owner" => true,
                "notify_new_entity_owner" => true
            ]
        ]
    ]);

    $convertResponse = makeCurlRequest($convertUrl, 'POST', ['Authorization: Zoho-oauthtoken ' . $zohoToken, 'Content-Type: application/json'], $convertPayload);
    // print_r($convertResponse); die; 
    $contact_id = $convertResponse->data[0]->details->Contacts->id ?? null;
}
}

// Search for lead by mobile number in Zoho CRM
// $leadUrl = 'https://www.zohoapis.in/crm/v3/Leads/search?phone=' . $mobileNumber;
// $leadResponse = makeCurlRequest($leadUrl, 'GET', ['Authorization: Zoho-oauthtoken ' . $zohoToken]);
// $data = $leadResponse->data[0] ?? null;

// $lead_id = $data->id ?? null;

// if ($lead_id) {
//     // Convert lead to contact
//     $convertUrl = 'https://www.zohoapis.in/crm/v6/Leads/' . $lead_id . '/actions/convert';
//     $convertPayload = json_encode([
//         "data" => [
//             [
//                 "overwrite" => true,
//                 "notify_lead_owner" => true,
//                 "notify_new_entity_owner" => true
//             ]
//         ]
//     ]);

//     $convertResponse = makeCurlRequest($convertUrl, 'POST', ['Authorization: Zoho-oauthtoken ' . $zohoToken, 'Content-Type: application/json'], $convertPayload);
//     print_r($convertResponse); die; 
//     $contact_id = $convertResponse->data[0]->details->Contacts->id ?? null;
// } else {
//     // Search for contact if lead does not exist
//     $contactUrl = 'https://www.zohoapis.in/crm/v3/Contacts/search?phone=' . $mobileNumber;
//     $contactResponse = makeCurlRequest($contactUrl, 'GET', ['Authorization: Zoho-oauthtoken ' . $zohoToken]);
//     $contact_id = $contactResponse->data[0]->id ?? null;
// }

if ($contact_id) {
   
    // Create a new deal
    $dealUrl = 'https://www.zohoapis.in/crm/v6/Deals';
    $dealPayload = json_encode([
        "data" => [
            [
                "Deal_Name" => $orderNo,
                "Contact_Name" => $contact_id,
                "Stage" => "Closed Won",
                "Order_ID" => $orderId,
                "Order_Placed_date" => $placed_date,
                "Order_No" => $orderNo,
                "Customer_ID" => $customerId,
                "Status" => $status,
                "Source" => $source,
                "Appointment_Id" =>$appointmentId,
                "Net_Sales" =>$netSales,
                "User_Id"=>$userId,
                "Customer_Name" =>$customerName,
                "Discount_Applied1" =>$discountApplied,
                "Total"=>$total,
                "Order_Details" => $subform["Order_Details"] // Pass the array directly
            ]
        ]
    ]);
    $dealResponse = makeCurlRequest($dealUrl, 'POST', ['Authorization: Zoho-oauthtoken ' . $zohoToken, 'Content-Type: application/json'], $dealPayload);
    $json_deal = json_encode($dealResponse);
    echo $json_deal;
    $deal_id = $dealResponse->data[0]->details->id;
    //  die;
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => 'https://www.zohoapis.in/crm/v3/Potentials/'.$deal_id.'/Products',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'PUT',
      CURLOPT_POSTFIELDS =>$jsonResult,
      CURLOPT_HTTPHEADER => array(
        'Authorization: Zoho-oauthtoken '.$zohoToken,
        'Content-Type: application/json'
      ),
    ));
    
    $response = curl_exec($curl);
    
    curl_close($curl);
    echo $response;
} else {
    echo "No lead or contact exists";
}
// Example usage: Log whenever the code is hit
logMessage($json_deal,$all_value);
function logMessage($message,$all_value, $logFile = 'app_log_order.txt') {
    // Set the path for the log file
    $logFilePath = __DIR__ . '/' . $logFile;

    // Get the current date and time
    $currentDateTime = date('Y-m-d H:i:s');

    // Format the log message
    $logMessage = "[" . $currentDateTime . "] " ."data =".$all_value." response =". $message . PHP_EOL;

    // Write the log message to the log file (append mode)
    file_put_contents($logFilePath, $logMessage, FILE_APPEND);
}

?>