<?php
// Allow requests from any origin
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");

$requestBody = file_get_contents('php://input');

$decode_response = json_decode($requestBody, true);

$mobileNumber = $decode_response['mobileNumber'];
// Helper function to handle cURL requests
function makeCurlRequest($url, $method = 'GET', $headers = [], $postFields = null) {
    $curl = curl_init();
    curl_setopt_array($curl, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => $method,
        CURLOPT_HTTPHEADER => $headers,
    ]);

    if ($postFields) {
        curl_setopt($curl, CURLOPT_POSTFIELDS, $postFields);
    }

    $response = curl_exec($curl);
    if (curl_errno($curl)) {
        curl_close($curl);
        return null; // Handle error in the calling function
    }

    curl_close($curl);
    return json_decode($response);
}

function getDateAndTime($dateTimeString) {
    // Create a DateTime object from the input string
    $dateTime = new DateTime($dateTimeString);
    
    // Get the date part in 'Y-m-d' format
    $date = $dateTime->format('Y-m-d');
    
    // Get the time part in 'H:i:s' format
    $time = $dateTime->format('H:i:s');
    
    // Return an associative array with date and time
    $result = $date.'T'.$time.'+05:30';
    return $result;
}


$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://ageasybyantara.com/users/v1/public/external-user-login',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
    "username": "sumit.bounthiyal@motviz.com",
    "password": "X:@?K-r!j:kHOz&6"
}
',
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/json'
  ),
));

$response = curl_exec($curl);

curl_close($curl);
$token = json_decode($response)->accessToken;

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://ageasybyantara.com/appointment/v1/admin-management/latest-appointment?customerMobile='.$mobileNumber,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'x-access-token: '.$token
  ),
));

$response = curl_exec($curl);
$json_response=$response;
// echo $json_response;

curl_close($curl);

// echo $response;
$all_response = json_decode($response);
$appointmentId = $all_response->appointmentId;
$appointmentNo = $all_response->appointmentNo;
$appointmentMode = $all_response->appointmentMode;
$status = $all_response->status;
$expertName = $all_response->expertName;
$customerId = $all_response->customerId;
$conditionName = $all_response->conditionName;
$fromDate = $all_response->fromDate;
$toDate = $all_response->toDate;
$from = getDateAndTime($fromDate);
$to = getDateAndTime($toDate);
$appointmentSource = $all_response->appointmentSource;
$userId = $all_response->userId;
$customerName = $all_response->customerName;
// Define the file path
$file = 'check_appointment_number.txt';

$value_app = $status.$appointmentNo;
// Use file_get_contents to read the contents of the file
$text_app_no = file_get_contents($file);

if($value_app == $text_app_no){
    exit();
}
check_app($value_app);
function check_app($message, $logFile = 'check_appointment_number.txt') {
    // Set the path for the log file
    $logFilePath = __DIR__ . '/' . $logFile;

    // Write the log message to the log file (append mode)
     file_put_contents($logFilePath, $message);
}

if(empty($appointmentId)){
    echo "No appointment found";
    exit();
}
$all_value = '{
    "data": [
        {
            "id": "'.$app_id.'",
           "Appilcation_Id":"'.$appointmentId.'",
            "Application_Number": "'.$appointmentNo.'",
            "Status1": "'.$status.'",
            "Expert_Name": "'.$expertName.'",
            "Start_DateTime": "'.$from.'",
            "End_DateTime": "'.$to.'",
            "Application_Mode": "'.$appointmentMode.'",
            "Event_Title": "'.$conditionName.'",
            "Customer_Id_from_portal":"'.$customerId.'"
        }
    ]
}';
// Define the file path
$file = 'antara_token.txt';

// Use file_get_contents to read the contents of the file
$token = file_get_contents($file);

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://www.zohoapis.in/crm/v5/Events/search?criteria=Application_Number%3Aequals%3A'.$appointmentNo,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Authorization: Zoho-oauthtoken '.$token,
  ),
));

$response = curl_exec($curl);
$meeting = json_decode($response);
$data = $meeting->data;

if(!empty($data)){
foreach($data as $appoinment){
    $app_id = $appoinment->id;
    // print_r($app_id); die;
    // $app_date = $appoinment->Start_DateTime;

    // // Set the default timezone to Indian Standard Time (IST)
    // date_default_timezone_set('Asia/Kolkata');
    
    // // Define the provided date
    // $providedDate = new DateTime($app_date);
    
    // // Get the current date in IST
    // $currentDate = new DateTime();
    
    // // Check if the provided date is in the future
    // if ($providedDate > $currentDate) {
    //     $app_schedule = "true"; // Provided date is in the future
    // } else {
    //     $app_schedule = "false"; // Provided date is in the past or the same
    // }
//   if($app_schedule == "true")
//   {

$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://www.zohoapis.in/crm/v6/Events',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'PUT',
  CURLOPT_POSTFIELDS =>'{
    "data": [
        {
            "id": "'.$app_id.'",
           "Appilcation_Id":"'.$appointmentId.'",
            "Application_Number": "'.$appointmentNo.'",
            "Status1": "'.$status.'",
            "Expert_Name": "'.$expertName.'",
            "Start_DateTime": "'.$from.'",
            "End_DateTime": "'.$to.'",
            "Application_Mode": "'.$appointmentMode.'",
            "Event_Title": "'.$conditionName.'",
            "Customer_Id_from_portal":"'.$customerId.'"
        }
    ]
}',
  CURLOPT_HTTPHEADER => array(
    'Authorization: Zoho-oauthtoken '.$token,
    'Content-Type: application/json'
  ),
));

$response = curl_exec($curl);
curl_close($curl);
logMessage($response,$json_response);
echo  "Appoinment updated";   
 exit();
//   }

 }
}
curl_close($curl);
$contact_id =  null;
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://www.zohoapis.in/crm/v3/Leads/search?phone='.$mobileNumber,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Authorization: Zoho-oauthtoken '.$token
  ),
));

$response = curl_exec($curl);
curl_close($curl);
$all_response2 = json_decode($response);
$data = $all_response2->data['0'];
// print_r($data);
$lead_id = $data->id;
// echo $lead_id; die;
if(!empty($lead_id)){
      $convertUrl = 'https://www.zohoapis.in/crm/v6/Leads/' . $lead_id . '/actions/convert';
    $convertPayload = json_encode([
        "data" => [
            [
                "overwrite" => true,
                "notify_lead_owner" => true,
                "notify_new_entity_owner" => true
            ]
        ]
    ]);

    $convertResponse = makeCurlRequest($convertUrl, 'POST', ['Authorization: Zoho-oauthtoken ' . $token, 'Content-Type: application/json'], $convertPayload);
    $contact_id = $convertResponse->data[0]->details->Contacts->id ?? null;
    $module = "Contacts";
    $module_name = "Who_Id";
}
// $module = "Leads";
// $module_name = "What_Id";
// echo $lead_id;
if(empty($contact_id)){
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => 'https://www.zohoapis.in/crm/v3/Contacts/search?phone='.$mobileNumber,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'Authorization: Zoho-oauthtoken '.$token
      ),
    ));
    
    $response = curl_exec($curl);
    
    curl_close($curl);
    $all_response2 = json_decode($response);
    $data = $all_response2->data['0'];
    // print_r($data);
    $contact_id = $data->id;
    $module = "Contacts";
    $module_name = "Who_Id";
    
}

if(!empty($contact_id)){
$curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://www.zohoapis.in/crm/v6/Events',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS =>'{
    "data": [
        {
            "Appilcation_Id":"'.$appointmentId.'",
            "Application_Number": "'.$appointmentNo.'",
            "Status1": "'.$status.'",
            "Appointment_Source_Order":"'.$appointmentSource.'",
            "User_Id": "'.$userId.'",
            "customer_Name": "'.$customerName.'",
            "Expert_Name": "'.$expertName.'",
            "Start_DateTime": "'.$from.'",
            "End_DateTime": "'.$to.'",
            "Application_Mode": "'.$appointmentMode.'",
            "Event_Title": "'.$conditionName.'",
            "$se_module":"'.$module.'",
            "'.$module_name.'":"'.$contact_id.'",
            "Customer_Id_from_portal":"'.$customerId.'"
        }
    ]
}',

  CURLOPT_HTTPHEADER => array(
    'Authorization: Zoho-oauthtoken '.$token,
    'Content-Type: application/json',
  ),
));

$response = curl_exec($curl);

curl_close($curl);
echo $response;
}
else{
    echo "No lead or contact exist in crm";
}
function logMessage($message,$all_value, $logFile = 'antara_appoinment_log.txt') {
    // Set the path for the log file
    $logFilePath = __DIR__ . '/' . $logFile;

    // Set the timezone to India (Asia/Kolkata)
    date_default_timezone_set('Asia/Kolkata');
    
    // Get the current date and time in India
    $currentDateTime = date('Y-m-d H:i:s');

    // Format the log message
    $logMessage = "[" . $currentDateTime . "] " ."data =".$all_value." response =". $message . PHP_EOL;

    // Write the log message to the log file (append mode)
    file_put_contents($logFilePath, $logMessage, FILE_APPEND);
}

// Example usage: Log whenever the code is hit
logMessage($response,$all_value);
